/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.client.gui.components;

import com.nemonotfound.nemos.inventory.sorting.Constants;
import com.nemonotfound.nemos.inventory.sorting.client.gui.components.AbstractSortButton;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_636;
import net.minecraft.class_746;
import net.minecraft.class_9323;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSortAlphabeticallyButton
extends AbstractSortButton {
    public AbstractSortAlphabeticallyButton(AbstractSortButton.Builder<? extends AbstractSortAlphabeticallyButton> builder) {
        super(builder);
    }

    public void method_25348(double mouseX, double mouseY) {
        this.sortItems();
    }

    private void sortItems() {
        class_310 minecraft = class_310.method_1551();
        class_1703 menu = this.containerScreen.method_17577();
        int containerId = menu.field_7763;
        this.mergeAllItems(menu, containerId, minecraft);
        Map<Integer, Integer> sortedItemMap = this.createSortedItemMap(menu);
        this.swapItemsUntilSorted(sortedItemMap, minecraft, containerId);
        this.mergeAllItems(menu, containerId, minecraft);
    }

    private void mergeAllItems(class_1703 menu, int containerId, class_310 minecraft) {
        Map<ItemData, List<Map.Entry>> groupedItemMap = this.getSortedSlotItems(menu).stream().collect(Collectors.groupingBy(itemMap -> new ItemData(((class_1799)itemMap.getValue()).method_57353(), ((class_1799)itemMap.getValue()).method_7909().method_7864((class_1799)itemMap.getValue()))));
        groupedItemMap.forEach((key, mapEntryList) -> this.mergeItems((List<Map.Entry<Integer, class_1799>>)mapEntryList, menu, containerId, minecraft));
    }

    private Map<Integer, Integer> createSortedItemMap(class_1703 menu) {
        List<Map.Entry<Integer, class_1799>> itemMapEntries = this.getSortedSlotItems(menu);
        LinkedHashMap<Integer, Integer> sortedItemMap = new LinkedHashMap<Integer, Integer>();
        for (int i = 0; i < itemMapEntries.size(); ++i) {
            int newSlot = i + this.startIndex;
            int currentSlot = itemMapEntries.get(i).getKey();
            if (currentSlot == newSlot) continue;
            sortedItemMap.put(currentSlot, newSlot);
        }
        return sortedItemMap;
    }

    private void swapItemsUntilSorted(Map<Integer, Integer> sortedItemMap, class_310 minecraft, int containerId) {
        int cycles = 1000;
        while (!sortedItemMap.isEmpty() && cycles > 0) {
            Iterator<Map.Entry<Integer, Integer>> slotsIterator = sortedItemMap.entrySet().iterator();
            if (slotsIterator.hasNext()) {
                int targetSlot;
                Map.Entry<Integer, Integer> slotsEntry = slotsIterator.next();
                int currentSlot = slotsEntry.getKey();
                if (currentSlot == (targetSlot = slotsEntry.getValue().intValue())) {
                    slotsIterator.remove();
                    continue;
                }
                this.swapItems(minecraft.field_1761, containerId, currentSlot, targetSlot, minecraft.field_1724);
                if (sortedItemMap.containsKey(targetSlot)) {
                    sortedItemMap.put(currentSlot, sortedItemMap.get(targetSlot));
                } else {
                    slotsIterator.remove();
                }
                sortedItemMap.put(targetSlot, targetSlot);
            }
            --cycles;
        }
    }

    @NotNull
    private List<Map.Entry<Integer, class_1799>> getSortedSlotItems(class_1703 menu) {
        class_2371 slots = menu.field_7761;
        return IntStream.range(this.startIndex, this.calculateEndIndex(menu)).mapToObj(slotIndex -> Map.entry(slotIndex, ((class_1735)slots.get(slotIndex)).method_7677())).filter(itemStackEntry -> !((class_1799)itemStackEntry.getValue()).method_31574(class_1802.field_8162)).sorted(this.compare()).toList();
    }

    protected Comparator<Map.Entry<Integer, class_1799>> compare() {
        return Comparator.comparing(entry -> {
            class_1799 itemStack = (class_1799)entry.getValue();
            class_2561 itemName = itemStack.method_7909().method_7864(itemStack);
            return itemName.getString();
        });
    }

    private void mergeItems(List<Map.Entry<Integer, class_1799>> mapEntryList, class_1703 menu, int containerId, class_310 minecraft) {
        if (mapEntryList.size() <= 1) {
            return;
        }
        int leftSlotIndex = 0;
        int rightSlotIndex = mapEntryList.size() - 1;
        int cycles = 1000;
        while (leftSlotIndex < rightSlotIndex) {
            if (cycles <= 0) {
                Constants.LOG.warn("Merging items exceeded max. attempts. Please report a bug");
                break;
            }
            Map.Entry<Integer, class_1799> leftSlotEntry = mapEntryList.get(leftSlotIndex);
            Map.Entry<Integer, class_1799> rightSlotEntry = mapEntryList.get(rightSlotIndex);
            class_1735 leftSlot = (class_1735)menu.field_7761.get(leftSlotEntry.getKey().intValue());
            class_1735 rightSlot = (class_1735)menu.field_7761.get(rightSlotEntry.getKey().intValue());
            class_1799 leftItem = leftSlot.method_7677();
            if (!this.isFullStack(leftItem)) {
                this.swapItems(minecraft.field_1761, containerId, rightSlotEntry.getKey(), leftSlotEntry.getKey(), minecraft.field_1724);
            } else {
                ++leftSlotIndex;
            }
            if (rightSlot.method_7677().method_31574(class_1802.field_8162)) {
                --rightSlotIndex;
            }
            --cycles;
        }
    }

    private boolean isFullStack(class_1799 itemStack) {
        return itemStack.method_7947() >= itemStack.method_7914();
    }

    private void swapItems(class_636 gameMode, int containerId, int slot, int targetSlot, class_746 player) {
        this.pickUpItem(gameMode, containerId, slot, player);
        this.pickUpItem(gameMode, containerId, targetSlot, player);
        this.pickUpItem(gameMode, containerId, slot, player);
    }

    private void pickUpItem(class_636 gameMode, int containerId, int slot, class_746 player) {
        gameMode.method_2906(containerId, slot, 0, class_1713.field_7790, (class_1657)player);
    }

    record ItemData(class_9323 dataComponentMap, class_2561 component) {
    }
}

